<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
    
	


    <title>
        <?php if(is_front_page() || is_home()){
            echo get_bloginfo('name');
        } else{
            echo wp_title('');
        }?>
    </title>
    
    

    
    <style type="text/css">
        @font-face {
            font-family: 'BrutGrotest';
            src: url('<?php echo get_template_directory_uri(); ?>/fonts/Brut_Grotesque_WEB-Bold.woff') format('woff'),
               url('<?php echo get_template_directory_uri(); ?>/fonts/Brut_Grotesque_WEB-Bold.woff2') format('woff2');
            font-weight: 500;
        }

        @font-face {
            font-family: 'BrutGrotest';
            src: url('<?php echo get_template_directory_uri(); ?>/fonts/Brut_Grotesque_WEB-Bold_Italic.woff') format('woff'),
               url('<?php echo get_template_directory_uri(); ?>/fonts/Brut_Grotesque_WEB-Bold_Italic.woff2') format('woff2');
            font-weight: 500;
            font-style: italic;
        }

        @font-face {
            font-family: 'BrutGrotest';
            src: url('<?php echo get_template_directory_uri(); ?>/fonts/Brut_Grotesque_WEB-Italic.woff') format('woff'),
               url('<?php echo get_template_directory_uri(); ?>/fonts/Brut_Grotesque_WEB-Italic.woff2') format('woff2');
            font-weight: 400;
            font-style: italic;
        }

        @font-face {
            font-family: 'BrutGrotest';
            src: url('<?php echo get_template_directory_uri(); ?>/fonts/Brut_Grotesque_WEB-Regular.woff') format('woff'),
               url('<?php echo get_template_directory_uri(); ?>/fonts/Brut_Grotesque_WEB-Regular.woff2') format('woff2');
            font-weight: 400;
        }

        @font-face {
            font-family: 'BrutGrotest';
            src: url('<?php echo get_template_directory_uri(); ?>/fonts/Brut_Grotesque_WEB-Light.woff') format('woff'),
               url('<?php echo get_template_directory_uri(); ?>/fonts/Brut_Grotesque_WEB-Light.woff2') format('woff2');
            font-weight: 300;
        }

        @font-face {
            font-family: 'BrutGrotest';
            src: url('<?php echo get_template_directory_uri(); ?>/fonts/Brut_Grotesque_WEB-Thin.woff') format('woff'),
               url('<?php echo get_template_directory_uri(); ?>/fonts/Brut_Grotesque_WEB-Thin.woff2') format('woff2');
            font-weight: 200;
        }

        @font-face {
            font-family: 'BrutGrotest';
            src: url('<?php echo get_template_directory_uri(); ?>/fonts/Brut_Grotesque_WEB-Thin_Italic.woff') format('woff'),
               url('<?php echo get_template_directory_uri(); ?>/fonts/Brut_Grotesque_WEB-Thin_Italic.woff2') format('woff2');
            font-weight: 200;
            font-style: italic;
        }
        

 
    </style>  

    
	<?php wp_head(); ?>
    
	<script async src="https://www.googletagmanager.com/gtag/js?id=G-TWQB3LR5W8"></script>
	<script>
	  window.dataLayer = window.dataLayer || [];
	  function gtag(){dataLayer.push(arguments);}
	  gtag('js', new Date());

	  gtag('config', 'G-TWQB3LR5W8');
	</script>

</head>




<body <?php body_class(); ?>>


<header>

    <div class="main_menu">
        <nav class="inner_main_menu">

            <div class="menu_global">

                <div class="menu_icon_mobile">
                    <img src="<?php echo get_template_directory_uri(); ?>/img/menu.svg" alt="">
                </div>

                <div class="menu_icon_desk">Menu</div>


                <div class="container_menu">
					
					<div class="menu_nav_mobile">
						<div class="menu_nav_mobile_title">Menu</div>
						<div class="menu_nav_mobile_exit"><img src="<?php echo get_template_directory_uri(); ?>/img/exit.svg" alt=""></div>
					</div>
					
                    <div class="container_menu_inner">
                    
                    <?php 
                        wp_nav_menu( array(
                            'menu' => 'Main Menu',
                            'theme_location' => 'navbar',
                            'menu_class' => 'menu_screen',
                            'fallback_cb'    => '__return_false',
                        ));   
                    ?>
                    </div>
					
					<div class="menu_global_footer">
				<h4>Join our waitlist</h4>
						
				<h4>Social Medias</h4>
				<ul class="all_logo">
				  <li><a href=""><img src="<?php echo get_template_directory_uri(); ?>/img/ee2db49a7ef1bdcbc70d8d705b9eecbc.png" alt=""></a></li>
				  <li><a href=""><img src="<?php echo get_template_directory_uri(); ?>/img/373dec2c4f787f9ab318adee80e8e5fc.png" alt=""></a></li>
				  <li><a href=""><img src="<?php echo get_template_directory_uri(); ?>/img/b37a4a6e753dd65eeac83c98e5ab34b1.png" alt=""></a></li>
				  <li><a href=""><img src="<?php echo get_template_directory_uri(); ?>/img/65d03efb3def065e91a2585d749096ae.png" alt=""></a></li>

				</ul>
					</div>
					
					
					
                </div>

            </div>



            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="title_site">
                <h1>
                    <?php echo get_bloginfo('name'); ?>
                </h1>
            </a>

            
            <a href=></a>



        </nav>
    </div>
</header>







<script>
	document.querySelector(".menu_icon_desk").addEventListener("mouseenter", (event) => {
		if( window.innerWidth >= 820){
        document.querySelector(".container_menu").style.gridTemplateRows = "1fr";
		}
	}, false);


    var into_nav = false;
    var disappear_nav;

    document.querySelector(".main_menu").addEventListener("mousemove", (event) => {
        into_nav = true;
        window.clearTimeout(disappear_nav);
	}, false);

    document.querySelector(".main_menu").addEventListener("mouseleave", (event) => {
        into_nav = false;
        disappear_nav = setTimeout(() => {
            if (into_nav == false){
                document.querySelector(".container_menu").style.gridTemplateRows = "0fr"
            }
        }, 500);
	}, false);
	
	
	
	document.querySelector(".menu_icon_mobile").addEventListener("click", (event) => {
		if( window.innerWidth <= 820){
        	document.querySelector(".container_menu").style.right = "0";
			document.querySelector("body").style.overflow = "hidden";
		}
	}, false);
	
	document.querySelector(".menu_nav_mobile_exit").addEventListener("click", (event) => {
        document.querySelector(".container_menu").style.right = "100%";
		document.querySelector("body").style.overflow = "auto";
	}, false);
	
    
</script>






